/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test sca_matrix

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_util::sca_matrix<double> m;

  // check empty

  std::cout << "Rows: " << m.n_cols()
            << " - Cols: " << m.n_rows()
            << " - resizable: " << std::boolalpha << m.is_auto_resizable()
            << std::endl;

  m.resize( 4, 3 );

  std::cout << "Rows: " << m.n_cols()
            << " - Cols: " << m.n_rows()
            << " - resizable: " << std::boolalpha << m.is_auto_resizable()
            << std::endl;

  // check initialisation

  bool check = true;

  for (unsigned i = 0; i < m.n_cols(); ++i)
    for (unsigned j = 0; j < m.n_rows(); ++j)
      check = check && ( m(i, j) == 0. );

  std::cout << "Init: " << check << std::endl;

  // check access

  sca_util::sca_matrix<double> const & m_const = m; // enforce constness

  m(1, 1) = 42;
  std::cout << "m(1,1) == " << m(1, 1) << " == " << m_const(1, 1) << std::endl;

  // out-of-bounds access
  double const & foo = m_const(4, 3);
  std::cout << "foo == " << foo << " == m(4,3) == " << m_const(4, 3) << std::endl;

  m(4, 3) = 17;
  std::cout << "foo == " << foo << " == m(4,3) == " << m_const(4, 3) << std::endl;

  // turn off auto resize
  m.unset_auto_resizable();

  std::cout << "Rows: " << m.n_cols()
            << " - Cols: " << m.n_rows()
            << " - resizable: " << std::boolalpha << m.is_auto_resizable()
            << std::endl;

#if TEST_CPLUSPLUS >= 201103L

  sca_util::sca_matrix<int> mi = {{11, 12}, {21, 22}, {31, 32}, {41, 42}};

  if (mi.n_cols() != 2)
  {
    SC_REPORT_ERROR("sca_vector", "C++11 Initializer list test failed - wrong number columns");
  }

  if (mi.n_rows() != 4)
  {
    SC_REPORT_ERROR("sca_matrix", "C++11 Initializer list test failed - wrong number rows");
  }

  for (unsigned long i = 0; i < mi.n_cols(); i++)
    for (unsigned long j = 0; j < mi.n_rows(); j++)
    {
      if (mi(j, i) != int(10 * (j + 1) + (i + 1)))
      {
        std::cout << std::endl << mi << std::endl;
        SC_REPORT_ERROR("sca_matrix", "C++11 Initializer list test failed - wrong value");
      }
    }


  sca_util::sca_matrix<double> md = { {11.0, 12.0}, {21.0, 22.0}, {31.0, 32.0}, {41.0, 42.0} };

  if (md.n_cols() != 2)
  {
    SC_REPORT_ERROR("sca_vector", "C++11 Initializer list test failed - wrong number columns");
  }

  if (md.n_rows() != 4)
  {
    SC_REPORT_ERROR("sca_matrix", "C++11 Initializer list test failed - wrong number rows");
  }

  for (unsigned long i = 0; i < md.n_cols(); i++)
    for (unsigned long j = 0; j < md.n_rows(); j++)
    {
      if (int(md(j, i)) != int(10 * (j + 1) + (i + 1)))
      {
        std::cout << std::endl << md << std::endl;
        SC_REPORT_ERROR("sca_matrix", "C++11 Initializer list test failed - wrong value");
      }
    }

  sca_util::sca_matrix<sca_util::sca_complex> mc =
  { { {11.0,-12.0} , {12.0,-13.0} },
      { {21.0,-22.0} , {22.0,-23.0} },
      { {31.0,-32.0} , {32.0,-33.0} },
      { {41.0,-42.0} , {42.0,-43.0} }
  };

  if (mc.n_cols() != 2)
  {
    SC_REPORT_ERROR("sca_vector", "C++11 Initializer list test failed - wrong number columns");
  }

  if (mc.n_rows() != 4)
  {
    SC_REPORT_ERROR("sca_matrix", "C++11 Initializer list test failed - wrong number rows");
  }

  for (unsigned long i = 0; i < mc.n_cols(); i++)
    for (unsigned long j = 0; j < mc.n_rows(); j++)
    {
      if ( (int(mc(j, i).real()) != (10 * (j + 1) + (i + 1))) | 
           (int(mc(j, i).imag()) != -(int)(10 * (j + 1) + (i + 1) + 1)))
      {
        std::cout << std::endl << mc << std::endl;
        SC_REPORT_ERROR("sca_matrix", "C++11 Initializer list test failed - wrong value");
      }
    }

#endif

  // out-of-bounds access
  std::cout << "test error reporting for out-of-bounds access..." << std::endl;
  try
  {
    m(5, 3);
  }
  catch ( const sc_core::sc_report & r )
  {
    std::cout << "expected error occurred" << std::endl;
  }

  TEST_LABEL_END;

  return 0;
}
