/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test TDF module creation, macros, instantiation, constructor and kind
// test if sca_tdf::sca_module is derived from sca_core::sca_module

#include <systemc-ams>
#include "test_utilities.h"

// using macros
SCA_TDF_MODULE( my_tdf_module1 ) 
{
  SCA_CTOR( my_tdf_module1 )
  {
    std::cout << "constructor: my_tdf_module1" << std::endl;
  }

  ~my_tdf_module1() {}
};

// using full syntax
class my_tdf_module2 : public sca_tdf::sca_module
{
public:
  my_tdf_module2( sc_core::sc_module_name nm )
  {
    std::cout << "constructor: my_tdf_module2" << std::endl;
  }

  ~my_tdf_module2() {}
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  my_tdf_module1 mod1("mod1");

  std::cout << "kind of mod1: ";
  std::cout << mod1.kind() << std::endl;

  const sc_core::sc_object* obj1 = &(mod1);

  std::cout << "kind of mod1 object: ";
  std::cout << obj1->kind() << std::endl;

  my_tdf_module2 mod2("mod2");

  std::cout << "kind of mod2: ";
  std::cout << mod2.kind() << std::endl;

  const sc_core::sc_object* obj2 = &(mod2);

  std::cout << "kind of mod2 object: ";
  std::cout << obj2->kind() << std::endl;

  my_tdf_module2* mod3 = new my_tdf_module2("mod3");

  // check if sca_tdf::sca_module is derived from sca_core::sca_module
  sca_core::sca_module* mod4 = dynamic_cast<sca_core::sca_module*>(mod3);

  std::cout << "kind of mod3 object: ";
  std::cout << mod3->kind() << std::endl;

  TEST_LABEL_END;

  delete mod3;

  return 0;
}
