/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test delay of primitive sca_lsf::sca_delay

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_lsf::sca_source step("step");

  sca_lsf::sca_source sin_src("sin_src");
  
  sca_lsf::sca_signal sig1, sig2;

  step.y(sig1);
  step.init_value = 1.1;
  step.offset = 3.0;
  step.delay = sca_core::sca_time(5.0, sc_core::SC_MS);
  step.set_timestep(0.25, sc_core::SC_MS);
  
  sin_src.y(sig2);
  sin_src.init_value = 3.0;
  sin_src.offset = 1.5;
  sin_src.amplitude = 1.5;
  sin_src.frequency = 50.0;
  sin_src.phase = 2.0 * M_PI * 0.25;
  sin_src.delay = sca_core::sca_time(5.0, sc_core::SC_MS);
  sin_src.set_timestep(0.25, sc_core::SC_MS);

  sca_util::sca_trace_file* atf = sca_util::sca_create_tabular_trace_file("test01");

  sca_util::sca_trace(atf, sig1, "sig1");
  sca_util::sca_trace(atf, sig2, "sig2");

  sc_core::sc_start(30.0, sc_core::SC_MS);

  sca_util::sca_close_tabular_trace_file(atf);

  test_util::check_results("test01", 2);

  TEST_LABEL_END;

  return 0;
}
