/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test kind() function, constructor arguments, and default values of sca_eln::sca_isource

#include <systemc-ams>
#include "test_utilities.h"

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_eln::sca_isource i_isource("i_isource");

  std::cout << "i_isource.kind(): " << i_isource.kind() << std::endl;

  std::cout << "i_isource.p.kind(): " << i_isource.p.kind() << std::endl;
  std::cout << "i_isource.p.name(): " << i_isource.p.name() << std::endl;

  std::cout << "i_isource.n.kind(): " << i_isource.n.kind() << std::endl;
  std::cout << "i_isource.n.name(): " << i_isource.n.name() << std::endl;

  std::cout << "i_isource.init_value.kind(): " << i_isource.init_value.kind() << std::endl;
  std::cout << "i_isource.init_value.name(): " << i_isource.init_value.name() << std::endl;
  std::cout << "default value of init_value: " << i_isource.init_value << std::endl;

  std::cout << "i_isource.offset.kind(): " << i_isource.offset.kind() << std::endl;
  std::cout << "i_isource.offset.name(): " << i_isource.offset.name() << std::endl;
  std::cout << "default value of offset: " << i_isource.offset << std::endl;

  std::cout << "i_isource.amplitude.kind(): " << i_isource.amplitude.kind() << std::endl;
  std::cout << "i_isource.amplitude.name(): " << i_isource.amplitude.name() << std::endl;
  std::cout << "default value of amplitude: " << i_isource.amplitude << std::endl;

  std::cout << "i_isource.frequency.kind(): " << i_isource.frequency.kind() << std::endl;
  std::cout << "i_isource.frequency.name(): " << i_isource.frequency.name() << std::endl;
  std::cout << "default value of frequency: " << i_isource.frequency << std::endl;

  std::cout << "i_isource.phase.kind(): " << i_isource.phase.kind() << std::endl;
  std::cout << "i_isource.phase.name(): " << i_isource.phase.name() << std::endl;
  std::cout << "default value of phase: " << i_isource.phase << std::endl;

  std::cout << "i_isource.delay.kind(): " << i_isource.delay.kind() << std::endl;
  std::cout << "i_isource.delay.name(): " << i_isource.delay.name() << std::endl;
  std::cout << "default value of delay: " << i_isource.delay << std::endl;

  std::cout << "i_isource.ac_amplitude.kind(): " << i_isource.ac_amplitude.kind() << std::endl;
  std::cout << "i_isource.ac_amplitude.name(): " << i_isource.ac_amplitude.name() << std::endl;
  std::cout << "default value of ac_amplitude: " << i_isource.ac_amplitude << std::endl;

  std::cout << "i_isource.ac_phase.kind(): " << i_isource.ac_phase.kind() << std::endl;
  std::cout << "i_isource.ac_phase.name(): " << i_isource.ac_phase.name() << std::endl;
  std::cout << "default value of ac_phase: " << i_isource.ac_phase << std::endl;

  std::cout << "i_isource.ac_noise_amplitude.kind(): " << i_isource.ac_noise_amplitude.kind() << std::endl;
  std::cout << "i_isource.ac_noise_amplitude.name(): " << i_isource.ac_noise_amplitude.name() << std::endl;
  std::cout << "default value of ac_noise_amplitude: " << i_isource.ac_noise_amplitude << std::endl;

  TEST_LABEL_END;

  return 0;
}
