/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test eln solver iteration dtdf -
// correct integration with variable timesteps

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE( source )
{
  sca_tdf::sca_out<double> outp;

  void set_attributes()
  {
    set_timestep(1.0, sc_core::SC_SEC);
    does_attribute_changes();
  }

  void initialize()
  {
    cnt=-1;
  }

  void reinitialize()
  {}

  void processing()
  {
    outp.write(1.0/value);
  }

  void change_attributes()
  {
    cnt++;

    switch (cnt)
    {
      case 0:  // 1ms
        value = 1.0;
        break;
      case 1:  // 2ms
        value = 10.0;
        break;
      case 2:  // 2 ms
        value = 2.0;
        request_next_activation(sc_core::SC_ZERO_TIME);
        break;
      case 3:
        value = 1.0; // 2ms
        request_next_activation(sc_core::SC_ZERO_TIME);
        break;
      case 4:  // 3ms
        value = 1.0;
        break;
      case 5:  // 3ms
        value = 2.0;
        request_next_activation(sc_core::SC_ZERO_TIME);
        break;
      case 6:  // 4ms
        value = 1.0;
        break; 
      case 7:  // 5ms
        value = 1.0;
        break; 
      case 8:  // 6ms
        value = 1.0;
        break;
      default: // 7ms
        sc_core::sc_stop();
        break;
    }
  }

  SCA_CTOR( source ) : outp("oupt"), cnt(0), value(1.0)
  {}

 private:
  long cnt;
  double value;
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1("sig1");
  sca_eln::sca_node n1("n1");
  sca_eln::sca_node_ref gnd;

  source src("src");
    src.outp(sig1);

  sca_eln::sca_isource isrc("isrc");
    isrc.p(n1);
    isrc.n(gnd);
    isrc.init_value = 1.0;
    isrc.offset = 1.0;

  sca_eln::sca_tdf_c c1("c1");
    c1.p(n1);
    c1.n(gnd);
    c1.inp(sig1);

  sca_util::sca_trace_file* tf = sca_util::sca_create_tabular_trace_file("test02.dat");
  sca_util::sca_trace(tf, sig1, "sig1");
  sca_util::sca_trace(tf, n1, "n1");

  sc_core::sc_start();

  sca_util::sca_close_tabular_trace_file(tf);

  test_util::check_results("test02", 2);

  TEST_LABEL_END;

  return 0;
}
