/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// my_event_detection example from user's guide

#include <systemc-ams>
#include "test_utilities.h"

SC_MODULE( gen_event )
{
  sc_core::sc_out<double> out;

  SC_CTOR( gen_event ) : out("out"), i(1.1)
  {
    SC_THREAD(events);
  }

  void events()
  {
    while (true)
    {
      wait(0.1, sc_core::SC_MS);
      out.write(i++);
      wait(1, sc_core::SC_MS);
      out.write(i++);
    }
  }

 private:
  double i;
};


SCA_TDF_MODULE(my_event_detection)
{
  sca_tdf::sca_de::sca_in<double> inp;

  SCA_CTOR(my_event_detection) {}

  void set_attributes()
  {
    does_attribute_changes();
    set_timestep(1.0, sc_core::SC_MS);
  }

  void processing()
  {
    // time-domain signal processing behavior or algorithm
    double val = inp.read();
    std::cout << "@" << get_time() << " input value read: " << val << std::endl;
  }

  void change_attributes()
  {
    request_next_activation(inp);
  }
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sc_core::sc_signal<double> sig1;

  gen_event ev("ev");
    ev.out(sig1);

  my_event_detection m("m");
    m.inp(sig1);

  sc_core::sc_start(3, sc_core::SC_MS);
  
  TEST_LABEL_END;
    
  return 0;
}
