/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

// test ltf_multirate_filter from user's guide

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(ltf_multirate_filter)
{
  sca_tdf::sca_in<double>  in;
  sca_tdf::sca_out<double> out;

  ltf_multirate_filter( sc_core::sc_module_name nm, double fc_, double h0_ = 1.0)
  : in("in"), out("out"), fc(fc_), h0(h0_) {}

  void set_attributes()
  {
    in.set_rate(2);
  }
  
  void initialize()
  {
    num(0) = 1.0;
    den(0) = 1.0;
    den(1) = 1.0 /( 2.0 * M_PI * fc );
  }
 
  void processing()
  {
    out.write( filter( num, den, in, h0 ) );
  }

 private:
  sca_tdf::sca_ltf_nd filter; 
  sca_util::sca_vector<double> num, den;
  double fc;
  double h0;
};


SCA_TDF_MODULE(my_step)
{
  sca_tdf::sca_out<double> out; // output port

  SCA_CTOR(my_step) : out("out")
  {}

  void set_attributes()
  {
    out.set_timestep(1, sc_core::SC_MS);
  }

  void processing()
  {
    out.write(1.0);
  }

 private:
};

int sc_main( int, char*[] )
{
  TEST_LABEL_START;

  sca_tdf::sca_signal<double> sig1;
  sca_tdf::sca_signal<double> sig2;

  my_step step("step");
  
  ltf_multirate_filter filt1("filt1", 1e3, 1.0);

  step.out(sig1);

  filt1.in(sig1);
  filt1.out(sig2);

  sc_core::sc_start(10, sc_core::SC_MS);
  
  TEST_LABEL_END;
    
  return 0;
}
  
