/*****************************************************************************

  Licensed to Accellera Systems Initiative Inc. (Accellera) under one or
  more contributor license agreements.  See the NOTICE file distributed
  with this work for additional information regarding copyright ownership.
  Accellera licenses this file to you under the Apache License, Version 2.0
  (the "License"); you may not use this file except in compliance with the
  License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
  implied.  See the License for the specific language governing
  permissions and limitations under the License.

 *****************************************************************************/

/*
 * checks, that module delete before sc_stop() does not lead to a segfault
 * however, this will be an error, due module destruction before
 * end_of_simulation is not allowed
 */

#include <systemc-ams>
#include "test_utilities.h"

SCA_TDF_MODULE(tdf_src)
{
  sca_tdf::sca_out<double> out;

  SCA_CTOR(tdf_src)
  : out("out")
  {}

  void set_attributes()
  {
    set_timestep(1.0, sc_core::SC_US);
  }

  void processing()
  {
    double x = std::sin(2.0 * M_PI * 1.0e3 * get_time().to_seconds());
    out.write(x);
  }
};

/////////////////////////////////////////////////

void my_report_handler( const sc_core::sc_report& rep,
                        const sc_core::sc_actions& actions)
{
  if (rep.get_severity() == sc_core::SC_ERROR)
  {
    std::cout << "expected error occurred" << std::endl;

    return; // stop executable
    // sc_core::sc_stop(); // this gives this additional message SystemC simulation stopped by user
  }

  if (rep.get_severity() == sc_core::SC_WARNING)
  {
    std::cout << "expected warning occurred" << std::endl;
    TEST_LABEL_END;
    exit(0); // stop executable
    // sc_core::sc_stop(); // this gives this additional message SystemC simulation stopped by user
  }

  if (rep.get_severity() == sc_core::SC_INFO)
  {
    return; // ignore infos (e.g. sc_stop Info)
  }

  // redirect other errors to the default_handler
  std::cout << "not supported severity occurred" << std::endl;
  sc_core::sc_report_handler::default_handler(rep, actions);
  exit(0); // stop executable
}

/////////////////////////////////////////////////

int sc_main(int argn, char* argv[])
{
  TEST_LABEL_START;

  if (argn == 1)
    sc_core::sc_report_handler::set_handler(my_report_handler);

  // Source :
  sca_tdf::sca_signal<double> src_out;

  tdf_src* u_source = new tdf_src("u_source");
    u_source->out(src_out);

  sc_core::sc_start(10.0, sc_core::SC_MS);

  // here should no segfault happen
  delete u_source;

  sc_core::sc_stop();

  TEST_LABEL_END;

  return (EXIT_SUCCESS);
}


