/* Copyright
 * ========================================================================================
 * Project:		Accurate DRAM Model
 * Author:		Yi Wang, Nan Li, KTH
 * ID:			adm_basic_types.h, 1.2, 2010/11/16
 *
 * Description:	Define basic data types used in ADM interface
 *
 * ========================================================================================
 * Version History
 * ========================================================================================
 * Version 1.2: Added default constructor
 * Version 1.1: Added function copyTo() and setLength()
 * Version 1.0:	First version.
 * ========================================================================================
 */

#ifndef ADM_BASIC_TYPES_H_
#define ADM_BASIC_TYPES_H_

#include "systemc.h"

class adm_data {
public:
	/* constructors */
	adm_data() : m_len(0), m_data(0) {}
	adm_data(int data_len) : m_len(data_len < 0 ? 0 : data_len), m_data(0) {
		if (m_len) m_data = new unsigned char[m_len];
	}
	adm_data(const adm_data &copy) : m_len(copy.m_len), m_data(0) {
		if (m_len) {
			m_data = new unsigned char[m_len];
			for (int i = 0; i < m_len; ++i) {
				m_data[i] = copy.m_data[i];
			}
		}

	}
	virtual ~adm_data() {
		delete [] m_data;
	}

	adm_data & operator =(const adm_data &rhs) {
		delete [] m_data;
		m_len = rhs.m_len;
		if (m_len) {
			m_data = new unsigned char[m_len];
			for (int i = 0; i < m_len; ++i) {
				m_data[i] = rhs.m_data[i];
			}
		} else {
			m_data = 0;
		}

		return *this;
	}

	void copyFrom(const unsigned char *src) {
		for (int i = 0; i < m_len; ++i)
			m_data[i] = src[i];
	}

	void copyTo(unsigned char *dst) {
		for (int i = 0; i < m_len; ++i)
			dst[i] = m_data[i];
	}

	int getLength() const { return m_len; }
	void setLength(int newLen) {
		if (newLen > m_len) {
			delete [] m_data;
			m_len = newLen;
			m_data = new unsigned char[m_len];
		} else {
			m_len = newLen < 0 ? 0 : newLen;
			if (!m_len) delete [] m_data;
			m_data = 0;
		}
	}
	unsigned char operator[] (int pos) const { return m_data[pos]; }
	unsigned char & operator[] (int pos) { return m_data[pos]; }

private:
	int m_len;
	unsigned char *m_data;
};

#endif /* ADM_BASIC_TYPES_H_ */
