/**
 *
 * @file resource_user.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: event.cc 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#include "mem_area.hh"

namespace sctg
{
   MemArea::MemArea(const boost::property_tree::ptree& pt,
		    Configuration& config)
      :
      ResourceUser(pt, config)
   {
      size_ = pt.get<unsigned long int>("<xmlattr>.size");

   }

   MemArea::~MemArea()
   {


   }


   unsigned long int MemArea::getSize() const
   {
      return size_;
   }

}

// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
