/**
 *
 * @file tg_packet.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: tg_packet.hh 1916 2011-07-06 12:44:26Z lehton87 $
 *
 */

#ifndef SCTG_TG_PACKET_HH
#define SCTG_TG_PACKET_HH

#include "tg_token.hh"


/** A network packet abstraction
 *
 * tgPacket struct abstracts a network packet. These are passed
 * between resources and NoC models. tgPackets are parts of tgTokens
 * cut to smaller sizes.
 *
 */
struct tgPacket
{
   
   unsigned long int address;     ///< Destination network address 
   unsigned long int source;      ///< Source port ID
   unsigned long int return_port; ///< Which port to use for read response
   unsigned long int dstPort;     ///< Destination in_port ID
   unsigned long int size;        ///< Payload size in bytes
   unsigned long int respSize;    ///< Read response size in bytes
   unsigned long int burstSize;   ///< Size of memory request accesses
   unsigned char*    data;        ///< Actual data to be sent
   unsigned long int id;          ///< ID number, corresponds to token ID
   unsigned long int packets;      ///< To how many packets token is split
   RWtype            type;        ///< Either READ_CMD or WRITE_CMD
   
   /** Constructor to initialze all values to safe defaults
    */
   tgPacket()
      : address(0),
	source(0),
	return_port(0),
	dstPort(0),
	size(0),
	burstSize(0),
	data(0),
	id(0),
	packets(1),
	type(WRITE_CMD)
   {
   }
};

#endif



// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
