/**
 *
 * @file noc_factory.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: noc_factory.cc 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#include "noc_factory.hh"

#include <systemc>

namespace asebt
{
   namespace mesh_2d_sc_1
   {
      NocFactoryRTL1::NocFactoryRTL1(sctg::NocConfIf* nocConfIf)
	 :
	 _mesh_2x2(0),
	 _mesh_3x3(0),
	 _mesh_4x4(0),
	 _mesh_5x5(0),
	 _mesh_6x6(0),
	 _mesh_8x8(0)
      {
	 std::string nocSubType = nocConfIf->getNocSubType();
	 if(nocSubType == "2x2")
	 {
	    _mesh_2x2 = new 
	       mesh_2d_with_pkt_codec_sc_bfm<2, 2, 0, 32, 32, 8, 16, 5, 0, 0, 0, 1, 
	       0, 0, 4, 5000000, 5000000>("mesh_2d", nocConfIf);
	 }
	 else if(nocSubType == "3x3")
	 {
	    _mesh_3x3 = new 
	       mesh_2d_with_pkt_codec_sc_bfm<3, 3, 0, 32, 32, 8, 16, 5, 0, 0, 0, 1, 
	       0, 0, 4, 5000000, 5000000>("mesh_2d", nocConfIf);
	 }
	 else if(nocSubType == "4x4")
	 {
	    _mesh_4x4 = new 
	       mesh_2d_with_pkt_codec_sc_bfm<4, 4, 0, 32, 32, 8, 16, 5, 0, 0, 0, 1, 
	       0, 0, 4, 5000000, 5000000>("mesh_2d", nocConfIf);
	 }
	 else if(nocSubType == "5x5")
	 {
	    _mesh_5x5 = new 
	       mesh_2d_with_pkt_codec_sc_bfm<5, 5, 0, 32, 32, 8, 16, 5, 0, 0, 0, 1, 
	       0, 0, 4, 5000000, 5000000>("mesh_2d", nocConfIf);
	 }
	 else if(nocSubType == "6x6")
	 {
	    _mesh_6x6 = new 
	       mesh_2d_with_pkt_codec_sc_bfm<6, 6, 0, 32, 32, 8, 16, 5, 0, 0, 0, 1, 
	       0, 0, 4, 5000000, 5000000>("mesh_2d", nocConfIf);
	 }
	 else if(nocSubType == "8x8")
	 {
	    _mesh_8x8 = new 
	       mesh_2d_with_pkt_codec_sc_bfm<8, 8, 0, 32, 32, 8, 16, 5, 0, 0, 0, 1, 
	       0, 0, 4, 5000000, 5000000>("mesh_2d", nocConfIf);
	 }
	 else
	 {
	    std::ostringstream oss;
	    oss << "NocFactory (sc_1) unsupported subtype \""
		<< nocSubType << "\"";
	    throw std::runtime_error(oss.str().c_str());
	 }      
	 
      }
      
      NocFactoryRTL1::~NocFactoryRTL1()
      {
	 if(_mesh_2x2) {delete _mesh_2x2; _mesh_2x2 = 0;}
	 if(_mesh_3x3) {delete _mesh_3x3; _mesh_3x3 = 0;}
	 if(_mesh_4x4) {delete _mesh_4x4; _mesh_4x4 = 0;}
	 if(_mesh_5x5) {delete _mesh_5x5; _mesh_5x5 = 0;}
	 if(_mesh_6x6) {delete _mesh_6x6; _mesh_6x6 = 0;}
	 if(_mesh_8x8) {delete _mesh_8x8; _mesh_8x8 = 0;}
      }
            
   }
}


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

