/**
 * File:    ModelListener.java
 * Author:  Tomi Jantti <tomi.jantti@tut.fi>
 * Created: 29.3.2007
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.event;

import java.util.EventListener;



/**
 * ModelListener defines an  interface for objects that
 * that are interested in listening ModelEvents.
 */
public interface ModelListener extends EventListener {
	/** Invoked when a node is inserted to the model. */
	public void nodeInserted(ModelEvent e);

	/** Invoked when a node is removed from the model. */
	public void nodeRemoved(ModelEvent e);

	/** Invoked when a node is moved inside the model. */
	public void nodeMoved(ModelEvent e);
	
	/**
	 * Invoked when the structure of the model has changed starting from
	 * the node contained in ModelEvent.
	 */
	public void structureChanged(ModelEvent e);
}
