#!/bin/bash

#
# Simple bash script to generate bit complement pattern for mesh
#
# Generates file named result.xml
#
# Script leaves some attributes with dummy entries meant to
# be replaced:
# 
# BYTE_AMOUNT                       Token size
# EVENT_PERIOD                      Time between sends
# PACKET_SIZE                       Optionally cut tokens to smaller pieces
# RX_BUFF_SIZE, TX_BUFF_SIZE        Buffer sizes for agents, zero for infinite
# NOC_CLASS, NOC_TYPE, NOC_SUBTYPE  What model to use
# SUMMARY_FILE                      Summary file name
#
# Use for example sed to replace these with valid values.
#

#
# Update these to change the size of the mesh
# agents should be equal to cols*rows 
#
agents=16
cols=4
rows=4



echo "<?xml version='1.0'?>" > result.xml
echo "<!DOCTYPE system>" >> result.xml
echo "<system>" >> result.xml
echo "<xsm_version value=\"4\"/>" >> result.xml
echo "<application>" >> result.xml
echo "<task_graph>" >> result.xml

for (( task = 1; task <= $agents; task++ ))
do        
    echo "<task name=\"task${task}0\" id=\"${task}0\" class=\"general\">" >> result.xml
    echo "<in_port id=\"${task}00\"/>" >>result.xml    
    
    echo "<out_port id=\"${task}08$(($agents+1-$task))08\"/>" >> result.xml
    

    echo "<trigger>" >> result.xml
    echo "<in_port id=\"${task}00\"/>" >>result.xml

    
    echo "<exec_count>" >> result.xml
    echo "<op_count><int_ops><polynomial>" >> result.xml
    echo "<param value=\"0\" exp=\"0\"/>" >> result.xml
    echo "</polynomial></int_ops></op_count>" >>result.xml
    echo "<send out_id=\"${task}08$(($agents+1-$task))08\" prob=\"1\">" >> result.xml
    echo "<byte_amount><polynomial>" >> result.xml
    echo "<param value=\"BYTE_AMOUNT\" exp=\"0\"/>" >> result.xml
    echo "</polynomial></byte_amount></send>" >> result.xml
    echo "<next_state value=\"READY\"/>" >> result.xml
    echo "</exec_count>" >> result.xml

    

    echo "</trigger>" >> result.xml
    echo "</task>" >> result.xml

    echo "<task name=\"task${task}1\" id=\"${task}1\" class=\"general\">" >> result.xml
    echo "<in_port id=\"${task}099\"/>" >>result.xml
    echo "<trigger>" >> result.xml
    echo "<in_port id=\"${task}099\"/>" >>result.xml
    echo "<exec_count><op_count><int_ops><polynomial><param value=\"0.25\" exp=\"1\"/>" >> result.xml
    echo "</polynomial></int_ops></op_count></exec_count>" >> result.xml
    echo "</trigger>" >> result.xml
    echo "</task>" >> result.xml


    echo "<task_connection src=\"${task}08$(($agents+1-$task))08\" dst=\"$(($agents+1-$task))099\" />" >> result.xml


    echo "<task_connection src=\"$task\" dst=\"${task}00\" />" >> result.xml

done

echo "<event_list>" >> result.xml

for (( task = 1; task <= $agents; task++ ))
do
    echo "<event out_port_id=\"$task\" name=\"Event$task\" id=\"$task\" period=\"EVENT_PERIOD\" prob=\"1\" amount=\"1\" />" >> result.xml
done

echo "</event_list>" >> result.xml

echo "</task_graph>" >> result.xml
echo "</application>" >> result.xml

echo "<mapping>" >> result.xml

for (( task = 1; task <= $agents; task++ ))
do
    echo "<resource name=\"cpu$task\" id=\"$(($task-1))\" contents=\"mutable\">" >> result.xml
    echo "<group position=\"movable\" name=\"group$task\" id=\"$task\" contents=\"mutable\">" >> result.xml
    echo "<task position=\"movable\" name=\"Task${task}0\" id=\"${task}0\"/>" >> result.xml
    echo "<task position=\"movable\" name=\"Task${task}1\" id=\"${task}1\"/>" >> result.xml
    echo "</group>" >> result.xml
    echo "</resource>" >> result.xml    
done

echo "</mapping>" >> result.xml

echo "<platform>" >> result.xml
echo "<resource_list>" >> result.xml

for (( task = 1; task <= $agents; task++ ))
do
    echo "<resource name=\"cpu$task\" id=\"$(($task-1))\" frequency=\"50\" type=\"CPU_TYPE_1\" packet_size=\"PACKET_SIZE\" rx_buffer_size=\"RX_BUFF_SIZE\" tx_buffer_size=\"TX_BUFF_SIZE\">" >> result.xml
    echo "<port terminal=\"$task\"/>" >> result.xml
    echo "</resource>" >> result.xml    
done

echo "</resource_list>" >> result.xml
echo "<noc class=\"NOC_CLASS\" type=\"NOC_TYPE\" subtype=\"NOC_SUBTYPE\">" >> result.xml
echo "<router_list>" >> result.xml

x=0
y=0

for (( task = 1; task <= $agents; task++ ))
do
    echo "<router width=\"32\" id=\"$task\" name=\"router$task\" frequency=\"50\" type=\"router\">" >> result.xml
    echo "<port name=\"port$task\" id=\"$task\" type=\"port\" address=\"0x000${y}000$x\"/>" >> result.xml
    echo "</router>" >> result.xml
    if [ $x -lt $(($cols-1)) ]; then
	x=$(($x+1))
    else
	x=0
	y=$(($y+1))
    fi
done

echo "</router_list>" >> result.xml
echo "<terminal_list>" >> result.xml

for (( task = 1; task <= $agents; task++ ))
do
    echo "<connection port=\"$task\" router=\"$task\" name=\"terminal$task\" id=\"$task\"/>" >> result.xml
done

echo "<network_interface type=\"ni\"/>" >> result.xml
echo "</terminal_list>" >> result.xml
echo "</noc>" >> result.xml
echo "</platform>" >> result.xml

echo "<constraints>" >> result.xml
echo "<rng_seed value=\"42\"/>" >> result.xml
echo "<sim_resolution time=\"1.0\" unit=\"ns\"/>" >> result.xml
echo "<sim_length time=\"100.0\" unit=\"ms\"/>" >> result.xml
echo "<measurements time=\"2.0\" unit=\"ms\"/>" >> result.xml
echo "<pe_lib file=\"examples/pe_lib.xml\"/>" >> result.xml
echo "<log_summary file=\"SUMMARY_FILE\"/>" >> result.xml
echo "<cost_function func=\"lat_tot_avg\"/>" >> result.xml
echo "<cost_function func=\"pu\"/>" >> result.xml
echo "</constraints>" >> result.xml

echo "</system>" >> result.xml