/**
 *
 * @file mesh_factory.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: mesh_factory.cc 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#include "mesh_factory.hh"

#include <systemc>

#include <iostream>
#include <stdexcept>
#include <string>

namespace asebt
{

   MeshFactory::MeshFactory(sctg::NocConfIf* nocConfIf)
      : _mesh_2d_sc_1(0),
	_mesh_2d_sc_2(0),
	_mesh_2d_sc_tlm_1(0)
#ifdef SCTG_USE_OCPTLM
      ,_mesh_2d_sc_ocp_tl3_1(0)
#endif
#ifdef SCTG_MIXED_LANGUAGE_SIM
      ,	_mesh_2d_vhd(0)
#endif
   {   
      std::string nocClass = nocConfIf->getNocClass();
      std::string nocType  = nocConfIf->getNocType();

      if(nocClass == "mesh_2d")
      {
	 if(nocType == "sc_rtl_1")
	 {
	    _mesh_2d_sc_1 = new asebt::mesh_2d_sc_1::NocFactory(nocConfIf);
	 }
	 else if(nocType == "sc_rtl_2")
	 {
	    _mesh_2d_sc_2 = new asebt::mesh_2d_sc_2::NocFactory(nocConfIf);
	 }
	 else if(nocType == "sc_tlm_1")
	 {	 
	    _mesh_2d_sc_tlm_1 = new asebt::mesh_2d_sc_tlm_1::Tlm1Factory
	       (nocConfIf);
	 }
#ifdef SCTG_USE_OCPTLM
	 else if(nocType == "sc_ocp_tl3_1")
	 {	 
	    _mesh_2d_sc_ocp_tl3_1 = new sctg::mesh_2d_sc_ocp_tl3_1::OcpTl3Factory
	       (nocConfIf);
	 }
#endif
#ifdef SCTG_MIXED_LANGUAGE_SIM
	 else if(nocType == "vhd")
	 {
	    _mesh_2d_vhd = new asebt::mesh_2d_vhd::NocFactory(nocConfIf);
	 }
#endif
	 else
	 {
	    std::ostringstream oss;
	    oss << "MeshFactory: NoC with class \"" << nocClass 
		<< "\" and type \"" << nocType << "\" not found";
	    throw std::runtime_error(oss.str().c_str());
	 }
      }
      else
      {
	 std::ostringstream oss;
	 oss << "MeshFactory: NoC with class \"" << nocClass 
	     << "\" and type \"" << nocType << "\" not found";
	 throw std::runtime_error(oss.str().c_str());
      }
   }

   MeshFactory::~MeshFactory()
   {
      if(_mesh_2d_sc_1) { delete _mesh_2d_sc_1; _mesh_2d_sc_1 = 0; }
      if(_mesh_2d_sc_2) { delete _mesh_2d_sc_2; _mesh_2d_sc_2 = 0; }
      if(_mesh_2d_sc_tlm_1) { delete _mesh_2d_sc_tlm_1; _mesh_2d_sc_tlm_1 = 0; }

// Using VHDL NoCs only when mixed language simulation is enabled
#ifdef SCTG_MIXED_LANGUAGE_SIM
      if(_mesh_2d_vhd) { delete _mesh_2d_vhd; _mesh_2d_vhd = 0; }
#endif

   }

}



// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

