// 
//  Copyright 2003 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//      Authors : Yann Bajot, PROSILOG
//                Alan Kamas, Sonics Inc.
//         $Id: SlaveSysC.h,v 1.2 2004/09/05 17:57:56 halexan Exp $
//  Description:  TL2 Slave used in the regression test 3 (see '.cpp' file for
//                more details)
// ============================================================================



#ifndef _ocp20SlaveSysC_h
#define _ocp20SlaveSysC_h

#include <iostream>
#include <map>
#include <deque>

// OCP-IP Channel header files
#include "ocp_globals.h"
#include "ocp_tl2_slave_port.h"
#include "ocp_tl_param_cl.h"

#include "SlaveThreadedRespQ.h"

#include "MemoryCl.h"


// define the SlaveSysC class
class SlaveSysC : public sc_module
{
  public:
    // --------------------------
    // public members and methods
    // --------------------------

    // type definitions
    typedef unsigned int Td;
    typedef unsigned int Ta;
    typedef map< Ta, Td > MemMapType;

    struct ReqQElement {
        OCPRequestGrp<Td,Ta> request;
        sc_time respSendTime;
    };

    // member definitions

    // channel port
    OCP_TL2_SlavePort<Td,Ta> tpP;

    // Systemc macros

    // has SystemC processes
    SC_HAS_PROCESS(SlaveSysC);

    // constructor and destructor
    SlaveSysC(sc_module_name, Ta, ostream* debug_os_ptr = NULL);
    ~SlaveSysC();

    // methods
    void setConfiguration( MapStringType& passedMap );
    void processRequest( OCPRequestGrp<Td,Ta>& req, unsigned int chunklen, bool chunklast, sc_time& send_time);
    void processReqQ(void);
    void freeSThreadBusy(void);

    void requestThreadProcess();
    void responseThreadProcess();

  private:
    // ---------------------------
    // private members and methods
    // ---------------------------

    // SystemC methods
    void end_of_elaboration();

    // methods
    bool MputDirect(int, bool, Td*, Ta, int);

    // member definitions

    // slave identification
    int  m_ID;

    // number of memory bytes and the memory array
    Ta   m_MemoryByteSize;

    // model a per thread response queue
    // must be a pointer as is a function of number of threads
    ThreadedRespQ<OCP_TL2_DataCl<Td,Ta> > *m_RespQueuePtr;

    MemoryCl<OCP_TL2_DataCl<Td,Ta> > *m_Memory;

    ostream* m_debug_os_ptr;

    // ------------------------------------------------------------
    //  Parameters of the connected OCP channel
    // ------------------------------------------------------------
    // TODO: this is awkward. Better to use it at end-of-elaboration time to set member values.
    ParamCl<OCP_TL2_DataCl<Td,Ta> >* m_OCPParamP;

    // Number of threads in the OCP channel
    int m_threads;

    // Does the channel use data handshaking?
    bool m_datahandshake;

    // Does the channel use data handshake accept?
    bool m_dataaccept;

    // Are writes with responses part of the OCP channel?
    bool m_writeresp_enable;

    // is SThreadBusy part of the OCP channel?
    bool m_sthreadbusy;

    // do we follow the rules of sthread_busy exact?
    bool m_sthreadbusy_exact;

    // is MThreadBusy part of the OCP channel?
    bool m_mthreadbusy;

    // is SCmdAccept part of the OCP channel?
    bool m_cmdaccept;

    // is MBurstSeq part of the OCP channel?
    bool m_burstseq;

    int m_addrIncr;

    // ------------------------------------------------------------
    //  Parameters of the Slave Model 
    // ------------------------------------------------------------

    // should there be a limit to the number of outstanding requests per thread?
    // default = false;
    bool m_limitreq_enable;

    // maximum number of outstanding requests per thread
    // default = 4;
    int m_limitreq_max;

    // Response Latency
    int *m_Latency;

    MapStringType m_ParamMap;

};

#endif // _ocp20SlaveSysC_h
