// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: slave.h,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP -  TL1 profile example
//
// ============================================================================

#ifndef _OCP_TL1_SLAVE_SYNC_H
#define _OCP_TL1_SLAVE_SYNC_H

#define DEBUG_G1

#include <iostream>


// OCP-IP Channel header files
#include "ocpip.h"
#include "fifo.h"

class Slave : public sc_core::sc_module {
  struct pending_req{
    pending_req(tlm::tlm_generic_payload* txn_, sc_dt::uint64 address_, unsigned int chunk_)
      : txn(txn_)
      , address(address_)
      , chunk(chunk_){}
      
    tlm::tlm_generic_payload* txn;
    sc_dt::uint64 address;
    unsigned int chunk;
  };
  
  struct outstanding_rsp{
    outstanding_rsp(tlm::tlm_generic_payload* txn_, sc_dt::uint64 address_, unsigned int chunk_)
      : txn(txn_)
      , address(address_)
      , chunk(chunk_){}
    tlm::tlm_generic_payload* txn;
    sc_dt::uint64 address;
    unsigned int chunk;
  };

public:  

  typedef ocpip::ocp_data_class_unsigned<32,32>::DataType Td;
  typedef ocpip::ocp_data_class_unsigned<32,32>::AddrType Ta;

  ocpip::ocp_slave_socket_tl1<32> wP;
  ocpip::ocp_slave_socket_tl1<32> rP;

  sc_core::sc_in_clk clk;

  SC_HAS_PROCESS(Slave);

  // constructor
  Slave(sc_core::sc_module_name name_);

  // destructor
  ~Slave();

  // Threads
  void proc_w();
  void proc_r();

  tlm::tlm_sync_enum nb_transport_r(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);
  tlm::tlm_sync_enum nb_transport_w(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);

  tlm::tlm_generic_payload* req_w, *req_r, *req_data;
  bool ongoing_resp_w, ongoing_resp_r;//, is_srmd_r;

  // OCP request 
  fifo<pending_req> pending_reqs_w;
  fifo<outstanding_rsp> outstanding_rsps_w, outstanding_rsps_r;
  tlm::tlm_generic_payload* current_txn_r, *current_txn_w;
  //bool request;
  unsigned int chunk_cnt_w, chunk_cnt_r, burst_length_r, burst_length_w;
  ocpip::burst_seqs current_seq_w, current_seq_r;
  tlm::tlm_generic_payload* ongoing_srmd_r;


  Ta address_w, address_r;
  Td memory[1024];
  tlm::tlm_phase phase;
  sc_core::sc_time time;
};

#endif
