// 
//  Copyright 2006 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//      Authors : Anssi Haverinen, Nokia
//                Herve Alexandrian, Sonics
//         $Id: read_map.cpp,v 1.1 2006/01/30 22:12:12 halexan Exp $
//
//  Description:  TL0-TL1 adapter demo
//                
// ============================================================================


#include <read_map.h>

void readMapFromFile(const string &myFileName, MapStringType &myParamMap) 
{
    // read pairs of data from the passed file
    string leftside;
    string rightside;
    
    // (1) open the file
    ifstream inputfile(myFileName.c_str());
    assert( inputfile );

    // set the formatting
    inputfile.setf(std::ios::skipws);

    // Now read through all the pairs of values and add them to the passed map
    while ( inputfile ) {
        inputfile >> leftside;
        inputfile >> rightside;
        myParamMap.insert(std::make_pair(leftside,rightside));
    }

    // All done, close up
    inputfile.close();
}


