// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc
//           $Id: 
//
//  Description : OSCI TLM based OCP TL3 channel definitions
//
// ============================================================================

#ifndef _OCP_TL3_CHANNEL_H
#define _OCP_TL3_CHANNEL_H

#include "ocp_tl3_master_protocol.h"
#include "ocp_tl3_slave_protocol.h"
#include "ocp_tl3_monitor_if.h"


template 
< typename REQ, 
  typename RESP
>
class OCP_TL3_Channel :
  public OCP_TL3_MonitorIF<REQ,RESP>,
  public sc_module
  {
  public:
    typedef REQ				  request_type;
    typedef RESP			  response_type;
    typedef OCP_TL3_MasterIF<REQ,RESP>	  master_interface_type;
    typedef OCP_TL3_SlaveIF<REQ,RESP>	  slave_interface_type;
    typedef tlm::tlm_fifo<request_type>	  request_fifo_type; 
    typedef tlm::tlm_fifo<response_type>   response_fifo_type;
    typedef OCP_TL3_Master_Protocol<request_type,response_type> master_protocol_type;
    typedef OCP_TL3_Slave_Protocol<request_type,response_type> slave_protocol_type;
    typedef typename OCP_TL3_MonitorIF<REQ,RESP>::observer_type observer_type;

    sc_export<master_interface_type> master_export;
    sc_export<slave_interface_type > slave_export;
  
    OCP_TL3_Channel(sc_module_name name):
      sc_module(name),
      master_export("ms"),
      slave_export("sl"),
      m_master_protocol("ms_prot",this),
      m_slave_protocol("sl_prot",this),
      m_request_fifo("req_fifo"),
      m_response_fifo("rsp_fifo")
    {
      // bind protocol layer to sc_exports
      master_export((master_interface_type&)m_master_protocol);
      slave_export ((slave_interface_type&) m_slave_protocol );

      // bind fifos to protocol layer
      m_master_protocol.m_requestPort(m_request_fifo);
      m_slave_protocol.m_requestPort(m_request_fifo);
      m_master_protocol.m_responsePort(m_response_fifo);
      m_slave_protocol.m_responsePort(m_response_fifo);
    }

    // implement OCP_TL3_MonitorPeekIF
    const std::string peekChannelName()	const
    {
      return name();
    }
    const std::string peekMasterPortName()	const
    {
      return master_export.name();
    }
    const std::string peekSlavePortName()	const
    {
      return slave_export.name();
    }
    const request_type& peekRequest()	const
    {
      m_request_fifo.nb_peek(m_tmp_req);
      return m_tmp_req;
    }
    const response_type& peekResponse()	const
    {
      m_response_fifo.nb_peek(m_tmp_resp);
      return m_tmp_resp;
    }
    bool requestInProgress() const
    {
      return m_master_protocol.requestInProgress();
    }
    bool responseInProgress() const
    {
      return m_slave_protocol.responseInProgress();
    }

    // implement OCP_TL3_MonitorRegisterIF
    void RegisterRequestStart(observer_type* monitor)
    { m_master_protocol.RegisterRequestStart(monitor); }
    void RegisterRequestEnd(observer_type* monitor)
    { m_slave_protocol.RegisterRequestEnd(monitor); }
    void RegisterResponseStart(observer_type* monitor)
    { m_slave_protocol.RegisterResponseStart(monitor); }
    void RegisterResponseEnd(observer_type* monitor)
    { m_master_protocol.RegisterResponseEnd(monitor); }

  protected:
    // OCP TL3 protocol layer
    master_protocol_type m_master_protocol;
    slave_protocol_type m_slave_protocol;
    // OSCI TLM fifos
    request_fifo_type	m_request_fifo;
    response_fifo_type	m_response_fifo;
    mutable request_type m_tmp_req;
    mutable response_type m_tmp_resp;
};

#endif
