#ifndef _SIMPLE_SLAVE_H
#define _SIMPLE_SLAVE_H

#include <map>

// OCP-IP Channel header files
#include "globals.h"
#include "ocp_tl1_slave_port.h"
#include "ocp_tl_param_cl.h"

#include "slave_response_queue.h"

#include "MemoryCl.h"


// define the Slave class
template <typename TdataCl>
class Slave : public sc_module, public OCP_TL_Config_Listener, public OCP_TL1_Master_TimingIF
{
  public:
    // --------------------------
    // public members and methods
    // --------------------------

    // type definitions
    typedef typename TdataCl::DataType Td;
    typedef typename TdataCl::AddrType Ta;
    typedef map< Ta, Td > MemMapType;

    // member definitions

    // channel port
    OCP_TL1_SlavePort<TdataCl> tpP;
    sc_in_clk clk;

    // Systemc macros

    // has SystemC processes
    SC_HAS_PROCESS(Slave);

    // constructor and destructor
    Slave(sc_module_name,
          int, Ta, ostream* debug_os_ptr = NULL);
    ~Slave();

    void requestThreadProcess();
    void responseThreadProcess();
    void exerciseSidebandThreadProcess();

    void set_configuration(OCPParameters& , std::string);
    void setOCPTL1MasterTiming(OCP_TL1_Master_TimingCl);
    void setModuleConfiguration(MapStringType&); 

  private:
    // ---------------------------
    // private members and methods
    // ---------------------------

    // SystemC methods
    void end_of_elaboration();

    // member definitions

    // slave identification
    int  m_ID;

    // ocp clock information
    sc_time m_clkPeriod;

    // number of memory bytes and the memory array
    Ta   m_MemoryByteSize;

    // model a per thread response queue
    ResponseQueue<TdataCl> m_ResponseQueue;

    MemoryCl<TdataCl> *m_Memory;

    ostream* m_debug_os_ptr;

    // current value of SThreadBusy as set by this Slave.
    int m_curSThreadBusy;

    // ------------------------------------------------------------
    //  Parameters of the connected OCP channel
    // ------------------------------------------------------------
    
    // Number of threads in the OCP channel
    int m_threads;

    // Does the channel use data handshaking?
    bool m_datahandshake;

    // Are writes with responses part of the OCP channel?
    bool m_writeresp_enable;

    // is SThreadBusy part of the OCP channel?
    bool m_sthreadbusy;

    // do we follow the rules of sthread_busy exact?
    bool m_sthreadbusy_exact;

    // is MThreadBusy part of the OCP channel?
    bool m_mthreadbusy;

    // is SCmdAccept part of the OCP channel?
    bool m_cmdaccept;

    // ------------------------------------------------------------
    //  Parameters of the Slave Model 
    // ------------------------------------------------------------

    // maximum number of outstanding requests per thread
    // default = 4;
    int m_limitreq_max;

    // Response Latency
    int m_Latency;

    OCPParameters m_parameters;

    sc_time m_mthreadbusy_sample_time;

};

#endif // _SIMPLE_SLAVE_H

