// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 04/09/2004
//
//  Description : TL1 example Slave
//
// ============================================================================

#ifndef _TL1_SLAVE_SYNC_H
#define _TL1_SLAVE_SYNC_H

// Turn on debug messages
#define DEBUG_G1

#include <iostream>

// User types
#include "channel_types.h"

// TLM classes
#include "ocp_globals.h"
#include "ocp_tl1_data_cl.h"
#include "tl_slave_if.h"

template <typename TdataCl>
class Slave : public sc_module {
public:  

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  sc_port< TLslaveIF<TdataCl>, 1> tpP;

  sc_in_clk clk;

  SC_HAS_PROCESS(Slave);

  // constructor
  Slave(sc_module_name name_);

  // destructor
  ~Slave();

  // Threads
  void proc_req();
  void proc_resp();

  // OCP request group
  OCPRequestGrp<Td,Ta> req;

  // OCP response group
  OCPResponseGrp<Td> resp;

  bool is_req;
  bool tmp;
  int last_request;

  sc_event send_response_event;

private:

  //
  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl*          m_DataCl;
  ParamCl<TdataCl>* m_ParamCl;
};

#endif
