///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

template<unsigned int BUSWIDTH>
OCPIP_VERSION::ocp_tl3_imc_logger::ocp_tl3_imc_logger(
    OCPIP_VERSION::infr::monitor<BUSWIDTH, tlm::tlm_base_protocol_types>& mon
  , const char* filename
  , unsigned int trace_extensions
  , unsigned int trace_data
  , unsigned int trace_be
  , bool check_release
)
  : OCPIP_VERSION::infr::ocp_observer_base(&mon)
  , m_trace_extensions(trace_extensions)
  , m_trace_data(trace_data)
  , m_trace_be(trace_be)
  , m_check_release(check_release)
{
  m_file.open(filename);
  if (m_file.fail()){
    std::cerr<<"Error: OCP TL3 IMC Monitor: could not create file "<<filename<<std::endl;
    exit(1);
  }
}


void OCPIP_VERSION::ocp_tl3_imc_logger::nb_call_callback(bool fwNbw
                     ,tlm::tlm_generic_payload& txn
                     ,const tlm::tlm_phase& phase
                     ,const sc_core::sc_time& time)
{
  if (m_check_release){
    release_detector* tmp=txn.get_extension<release_detector>();
    if (tmp) tmp->add_file(&m_file);
    else txn.set_auto_extension(release_detector::get_inst(&m_file, &txn));
  }
  m_file<<"@"<<sc_core::sc_time_stamp()<<"(+"<<time<<"), delta count="<<sc_core::sc_delta_count()<<std::endl
        <<"  CALL   nb_transport_"<<(fwNbw?"fw":"bw")<<"("<<&txn<<","<<phase<<")"<<std::endl;
  decode_txn(txn);
}


void OCPIP_VERSION::ocp_tl3_imc_logger::nb_return_callback(bool fwNbw
                       ,tlm::tlm_generic_payload& txn
                       ,const tlm::tlm_phase& phase
                       ,const sc_core::sc_time& time
                       ,tlm::tlm_sync_enum retVal)
{
  m_file<<"@"<<sc_core::sc_time_stamp()<<"(+"<<time<<"), delta count="<<sc_core::sc_delta_count()<<std::endl
        <<"  RETURN nb_transport_"<<(fwNbw?"fw":"bw")<<"("<<&txn<<")->";
  switch(retVal){
    case tlm::TLM_ACCEPTED: m_file<<"TLM_ACCEPTED"<<std::endl<<std::endl;; return;
    case tlm::TLM_UPDATED:  m_file<<"TLM_UPDATED :"<<phase<<std::endl; break;
    case tlm::TLM_COMPLETED:  m_file<<"TLM_COMPLETED"<<std::endl; break;
  }
  decode_txn(txn);
  m_file<<std::endl;
}


void OCPIP_VERSION::ocp_tl3_imc_logger::b_call_callback(tlm::tlm_generic_payload& txn, const sc_core::sc_time& time)
{
  m_file<<"@"<<sc_core::sc_time_stamp()<<"(+"<<time<<"), delta count="<<sc_core::sc_delta_count()<<std::endl
        <<"  CALL   b_transport("<<&txn<<")"<<std::endl;
  decode_txn(txn);
}


void OCPIP_VERSION::ocp_tl3_imc_logger::b_return_callback(tlm::tlm_generic_payload& txn, const sc_core::sc_time& time)
{
  m_file<<"@"<<sc_core::sc_time_stamp()<<"(+"<<time<<"), delta count="<<sc_core::sc_delta_count()<<std::endl
        <<"  RETURN b_transport("<<&txn<<")"<<std::endl;
  decode_txn(txn);
}


void OCPIP_VERSION::ocp_tl3_imc_logger::decode_txn(tlm::tlm_generic_payload& txn){
  m_file<<"    Command value="<<(txn.is_read()? "TLM_READ_COMMAND" : txn.is_write()? "TLM_WRITE_COMMAND" : "TLM_IGNORE_COMMAND")<<std::endl
        <<"    Address value=0x"<<std::hex<<txn.get_address()<<std::endl
//        <<"DataLength value="<<std::dec<<txn.get_data_length()<<std::endl
        <<"    StreamingWidth value="<<txn.get_streaming_width()<<std::endl
//        <<"ByteEnableLength value="<<txn.get_byte_enable_length()<<std::endl
        <<"    ResponseState value="<<txn.get_response_string()<<std::endl
        <<"    DMIHint value="<<(txn.is_dmi_allowed()? "Allowed" : "Not allowed")<<std::endl;

  if (m_trace_data){
    m_file<<"    Data array (length="<<txn.get_data_length()<<")"<<std::hex;
    for (unsigned int i=0; i<txn.get_data_length(); i++){
      if ((i % m_trace_data)==0) m_file<<std::endl<<"      ["<<i<<":"<<(i+m_trace_data-1)<<"]=0x";
      m_file<<(unsigned int)txn.get_data_ptr()[i]<<" ";
    }
    m_file<<std::endl;
  }

  if (m_trace_be){
    if (txn.get_byte_enable_ptr()){
      m_file<<"    Byte Enable array (length="<<txn.get_byte_enable_length()<<")"<<std::hex;
      for (unsigned int i=0; i<txn.get_byte_enable_length(); i++){
        if ((i % m_trace_be)==0) m_file<<std::endl<<"      ["<<i<<":"<<(i+m_trace_be-1)<<"]=0x";
        m_file<<(unsigned int)txn.get_byte_enable_ptr()[i]<<" ";
      }
    }
    else
      m_file<<"    Byte Enable array not used."<<std::hex;
    m_file<<std::endl;
  }
  
  if (m_trace_extensions){ 
    m_file<<"    Start of Extension List "<<std::hex<<std::endl; 
    for (unsigned int i=0; i<tlm::max_num_extensions(); i++){
      tlm::tlm_extension_base* tmp=txn.get_extension(i);
      if (tmp){
        OCPIP_VERSION::infr::ocp_base_extension_base*  ocp_base_ext=dynamic_cast<OCPIP_VERSION::infr::ocp_base_extension_base*>(tmp);
        if (ocp_base_ext) {
          unsigned int potential_guard_id;
          switch(ocp_base_ext->get_type(potential_guard_id)){
            //case ext::ocp_base_guard:
            case OCPIP_VERSION::infr::ocp_base_data:
              m_file<<"      "<<ocp_base_ext->dump()<<std::endl;
              break;
            case OCPIP_VERSION::infr::ocp_base_guarded_data:
              if (txn.get_extension(potential_guard_id) && ocp_base_ext->is_valid()) //only dump if guard is there
                m_file<<"      "<<ocp_base_ext->dump()<<std::endl;
              break;
            case OCPIP_VERSION::infr::ocp_base_array_guard:;
          }
        }
        else if (m_trace_extensions>1) m_file<<"      </extension name=\"unknown\" type=\"non-cop\" value=\"unknown\">"<<std::endl;
      }
    }
    m_file<<"    End of Extension List "<<std::hex<<std::endl; 
  }
}

