// 
//  (c) Copyright OCP-IP 2006
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Tim Kogel, CoWare Inc.
//         $Id: 
//
//  Description : declaration of simple OCP TL3 slave
//
// ============================================================================

#ifndef _OCP_TL3_SLAVE_H
#define _OCP_TL3_SLAVE_H

#include "ocp_tl3_slave_port.h"
#include "basic_protocol.h"


template <class Td, class Ta>
class ocp_tl3_slave : public sc_module
{
  typedef basic_protocol::basic_request<Td,Ta> requestType;
  typedef basic_protocol::basic_response<Td> responseType;
public:
  // this module has SC processes
  SC_HAS_PROCESS(ocp_tl3_slave);
  
  // OCP-specific TL3 specialized slave port 
  OCP_TL3_SlaveRequestPort<requestType>   ocp_req;
  OCP_TL3_SlaveResponsePort<responseType> ocp_resp;

  ocp_tl3_slave(sc_module_name mod);
  ~ocp_tl3_slave();

  void end_of_elaboration();
private:
  void get_request_method ();

  int m_sptr_resp_delay;
  int m_sptr_req_accept;

  responseType m_resp;
  int m_req_count_ocp;
  int m_resp_count_ocp;
};

#include "ocp_tl3_slave.cc"

#endif // _OCP_TL3_SLAVE_H
