// 
//  (c) Copyright OCP-IP 2006
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Tim Kogel, CoWare, Inc
//          $Id:
//
//  Description : definition of simple OCP TL3 bus
//
// ============================================================================

#ifndef _OCP_TL3_BUS_CPP
#define _OCP_TL3_BUS_CPP

template <typename Td, typename Ta>
ocp_tl3_bus<Td,Ta>::ocp_tl3_bus(sc_module_name mod, 
				unsigned int nbr_initiators, 
				unsigned int nbr_targets):
  sc_module(mod),
  ocp_s("SlaveP"),
  ocp_m("MasterP"),
  m_index(~0),
  m_previous_read_index(~0),
  m_outstanding_reads(0),
  m_clk_period(1, SC_NS),
  m_fifo(),
  m_nbr_initiators(nbr_initiators),
  m_nbr_targets(nbr_targets)
{
  SC_THREAD(request_thread);
  for (unsigned int i=0; i< m_nbr_initiators; i++) {
    sensitive << ocp_s.RequestStartEvent(i);
    cout << " bus_thread sensitive to interface " << i << endl;
  }

  SC_THREAD(response_thread);
  for (unsigned int i=0; i<m_nbr_targets; i++) {
    sensitive << ocp_m.ResponseStartEvent(i);
    cout << " response_thread sensitive to interface " << i << endl;
  }
  dont_initialize();
}

template <typename Td, typename Ta>
void
ocp_tl3_bus<Td,Ta>::end_of_elaboration() 
{
//   SC_THREAD(request_thread);
//   for (int i=0; i<ocp_s.size();i++) {
//     sensitive << ocp_s[i]->RequestStartEvent();
//     cout << " bus_thread sensitive to interface " << i << endl;
//   }
  
//   SC_THREAD(response_thread);
//   for (int i=0; i<ocp_m.size();i++) {
//     sensitive << ocp_m[i]->ResponseStartEvent();
//     cout << " response_thread sensitive to interface " << i << endl;
//   }
//   dont_initialize();
}



template <typename Td, typename Ta>
void
ocp_tl3_bus<Td,Ta>::request_thread() {  
  int n_active_masters;
  int active_master_id;
  int active_slave_id;
  bool is_read;
  unsigned int transfer_cycles;

  while(true) { 
    while(true) { 
      n_active_masters = 0;
      active_master_id = -1; // negative value means "undefined"
      active_slave_id = -1; // negative value means "undefined"
      
      cout << sc_time_stamp() << ", " << name() 
	   << ", collecting requests... active masters : ";

      for (unsigned int i=0; i<m_nbr_initiators; i++) {
	if(ocp_s[i]->requestInProgress()){
	  cout << i << " ";
	  n_active_masters++;
	  active_master_id = i; 
	  continue;
	}
      }
      cout << endl;
	
      if(!n_active_masters){
	break;
      }

      if ( !ocp_s[active_master_id]->getRequestBlocking(m_req) ) {
	cerr << "ERROR, " << sc_time_stamp() << ", " << name() 
	     << "::request_thread(), no request from master " 
	     << active_master_id << endl;
      }

      // save initiator id for the response path
      // based on the address, forward the request to target slave:
      m_index = (m_req.get_address() / 0x100) % m_nbr_targets;

      is_read = (m_req.type == basic_protocol::READ);

      if (is_read) {
	if ( m_previous_read_index != m_index ) {
	  cout << sc_time_stamp() << ", " << name() 
	       << ", m_outstanding_reads :" << m_outstanding_reads
	       << ", m_previous_read_index :" << m_previous_read_index
	       << ", m_index :" << m_index <<endl;
	  if ( m_outstanding_reads > 0 ) {
	    wait(m_resp_event);
	  }
	  m_previous_read_index = m_index;	    
	}
	m_outstanding_reads++;
	m_fifo.write(active_master_id);
      }
      transfer_cycles = 1;
      
      if (ocp_m[m_index]->requestInProgress()) {
	cout << sc_time_stamp() << ", " << name()
	     << ", target " << m_index << " is not yet ready \n";
	wait( ocp_m[m_index]->RequestEndEvent() );
      }
      if ( !ocp_m[m_index]->sendRequest(m_req) ) {
	cerr << "ERROR, " << sc_time_stamp() << ", " << name() 
	     << "::request_thread(), sedRequest to target " 
	     << m_index << " failed\n";
      }
      
      // wait for transfer delay
      cout << sc_time_stamp() << ", " << name() 
	   << "::request_thread() transfer-delay : " 
	   << transfer_cycles * m_clk_period << endl;
      wait( transfer_cycles * m_clk_period );
      
      // => release the request from the initiating master:
      ocp_s[active_master_id]->acceptRequest();
    }
    cout << sc_time_stamp() << ", " << name() << ": suspend \n";
    wait();
  }
}
    

template <typename Td, typename Ta>
void
ocp_tl3_bus<Td,Ta>::response_thread() {  
  int master_id;
  while(true){ 
    // check which master(s) is requesting bus: (iterate in this while loop until 
    // all requests processed)

    cout << sc_time_stamp() << ", " << name() << "::response_thread(),"
	 << " get request from " << m_previous_read_index << endl;
    if ( !ocp_m[m_previous_read_index]->getResponse(m_resp) ) {
      cerr << "ERROR, " << sc_time_stamp() << ", " << name() 
	   << "::response_thread(), no response from " 
	   << m_previous_read_index << endl;
    }


    // send the reponse to initiating master:
    master_id = m_fifo.read();
    if ( ocp_s[master_id]->responseInProgress() ) {
      cout << name() << " our master is not yet ready, so we'll wait for it\n";
      wait( ocp_s[master_id]->ResponseEndEvent() );
    }
    ocp_s[master_id]->sendResponseBlocking(m_resp);

    // wait for transfer delay
    cout << name() << "::response_thread transfer-delay : " 
	 <<  m_clk_period << endl;
    wait( m_clk_period );


    // master acknowledged response => release the response from the slave:
    m_outstanding_reads--;
    cout << sc_time_stamp() << ", " << name() 
	 << ", response_thread has sent response, outstanding reads : " 
	 << m_outstanding_reads << endl;
    if (m_outstanding_reads==0) m_resp_event.notify();
    ocp_m[m_previous_read_index]->acceptResponse();    
    // transaction completed. 

    // suspend thread until next response
    wait();
  }
}

#endif
