// Copyright 2003 OCP-IP
// OCP-IP Confidential & Proprietary

//////////////////////////////////////////////////
//
//  Master Interface for the OCP TL2 Channel
//
//////////////////////////////////////////////////

#ifndef _OCP_TL2_MASTER_IF
#define _OCP_TL2_MASTER_IF

#include "systemc.h"
#include "tl_master_if.h"
#include "ocp_tl2_data_cl.h"

template <class Tdata, class Taddr>
class OCP_TL2_MasterIF : virtual public TLmasterIF<OCP_TL2_DataCl<Tdata,Taddr> >
{
  public:

  //////////////////////////////////////////////////////////////
  // OCP TL2 Master specific methods
  //////////////////////////////////////////////////////////////

  // Structure-passing Methods (Synchronization AND Group Access)
  // 

  virtual bool sendOCPRequest(OCPRequestGrp<Tdata,Taddr>& req, unsigned int ReqChunkLen = 1, bool last_chunk_of_a_burst = true) = 0;
  virtual bool startOCPRequest(OCPRequestGrp<Tdata,Taddr>& req, unsigned int ReqChunkLen = 1, bool last_chunk_of_a_burst = true) = 0;
  virtual bool sendOCPRequestBlocking(OCPRequestGrp<Tdata,Taddr>& req, unsigned int ReqChunkLen = 1, bool last_chunk_of_a_burst = true) = 0;
  virtual bool startOCPRequestBlocking(OCPRequestGrp<Tdata,Taddr>& req, unsigned int ReqChunkLen = 1, bool last_chunk_of_a_burst = true) = 0;
  virtual bool getOCPResponse(OCPResponseGrp<Tdata>& resp, bool accept, unsigned int& RespChunkLen, bool& last_chunk_of_a_burst) = 0;
  virtual bool getOCPResponseBlocking(OCPResponseGrp<Tdata>& resp, bool accept, unsigned int& RespChunkLen, bool& last_chunk_of_a_burst) = 0;

  // Serialized Methods (useful for TL2 testbenches)
  //
  virtual bool OCPReadTransfer(OCPRequestGrp<Tdata,Taddr>& req, OCPResponseGrp<Tdata>& resp, unsigned int TransferLen = 1) = 0;
  virtual bool OCPWriteTransfer(OCPRequestGrp<Tdata,Taddr>& req, unsigned int TransferLen = 1) = 0;

  // Synchronization methods
  virtual bool getSBusy(void) const = 0;
  virtual bool getSCmdAccept(void) const = 0;
  virtual unsigned int getSThreadBusy(void) const = 0;
  virtual bool getSThreadBusyBit(unsigned int ThreadID = 0) const = 0;
  virtual bool putMRespAccept() = 0;
  virtual void putMThreadBusyBit(bool nextBitValue, unsigned int ThreadID = 0) = 0;
  virtual void putMThreadBusy(unsigned int nextMThreadBusy) = 0;
  virtual void waitSCmdAccept(void) = 0;

  // These methods can be used in place of Data Class methods (see below) to
  // set/get a complete group of signals (No synchronization is performed here)
  virtual void SetRequestFields(OCPRequestGrp<Tdata,Taddr>& req, unsigned int ReqChunkLen = 1, bool last_chunk_of_a_burst = true) = 0;
  virtual void GetResponseFields(OCPResponseGrp<Tdata>& resp, bool sdata_copy, unsigned int& RespChunkLen, bool& last_chunk_of_a_burst ) = 0;


  //////////////////////////////////////////////////////////////
  // TL2 Data Class methods
  //////////////////////////////////////////////////////////////
  
  // Request Group Access methods
  virtual void MputMAddr(Taddr a) = 0;
  virtual void MputMAddrSpace(unsigned int a) = 0;
  virtual void MputMAtomicLength(unsigned int a) = 0;
  virtual void MputMBurstSeq(OCPMBurstSeqType a) = 0;
  virtual void MputMByteEn(unsigned int a) = 0;
  virtual void MputMCmd(OCPMCmdType a) = 0;
  virtual void MputMConnID(unsigned int a) = 0;
  virtual void MputMData(Tdata* d, unsigned int w = 1, bool last_of_a_burst = true) = 0;
  virtual void MputMThreadID(unsigned int a) = 0;
  virtual void MputMBurstLength(unsigned int a) = 0;
  virtual void MputMBurstPrecise(bool a) = 0;
  virtual void MputMBurstSingleReq(bool a) = 0;
  virtual void MputMReqInfo(unsigned int a) = 0;
  virtual void MputMReqLast(bool a) = 0;


  // Response Group Access methods
  virtual Tdata* MgetSData(unsigned int& w, bool& last_of_a_burst) = 0;
  virtual Tdata* MgetSData(unsigned int& w) = 0;
  virtual Tdata* MgetSData() = 0;
  virtual unsigned int MgetSDataInfo() = 0;
  virtual OCPSRespType MgetSResp() = 0;
  virtual unsigned int MgetSRespInfo() = 0;
  virtual bool MgetSRespLast() = 0;
  virtual unsigned int MgetSThreadID() = 0;
  
  // DataHS Group Access methods
  virtual void MputMDataInfo(unsigned int a) = 0;
   
  // ThreadBusy Group Access methods
  virtual unsigned int MgetSThreadBusy(void) const = 0;
  virtual void MputMThreadBusy(unsigned int mthreadbusy) = 0;
  
  // SideBand Group Access methods
  virtual void MputMError(bool nextValue) = 0;
  virtual void MputMFlag(unsigned int nextValue) = 0;
  virtual void MputMReset_n(bool nextValue) = 0;
  virtual bool MgetSReset_n(void) const = 0;
  virtual bool MgetSError(void) const = 0;
  virtual unsigned int MgetSFlag(void) const = 0;
  virtual bool MgetSInterrupt(void) const = 0;
  virtual void SysputControl(int nextValue) = 0;
  virtual bool SysgetControlBusy(void) const = 0;
  virtual void SysputControlWr(bool nextValue) = 0;
  virtual unsigned int SysgetStatus(void) const = 0;
  virtual bool SysgetStatusBusy(void) const = 0;
  virtual void SysputStatusRd(bool nextValue) = 0;
  virtual unsigned int CgetControl(void) const = 0;
  virtual void CputControlBusy(bool nextValue) = 0;
  virtual bool CgetControlWr(void) const = 0;
  virtual void CputStatus(int nextValue) = 0;
  virtual void CputStatusBusy(bool nextValue) = 0;
  virtual bool CgetStatusRd(void) const = 0;


  // TL2-specific burst chunks methods
  virtual void MputMReqChunkLen(unsigned int w) = 0;
  virtual void MputMReqChunkLast(bool w) = 0;
  virtual unsigned int MgetSRespChunkLen() const = 0;
  virtual bool MgetSRespChunkLast() const = 0;
  

  // Event accesses
  virtual const sc_event& RequestStartEvent(void) const = 0;
  virtual const sc_event& RequestEndEvent(void) const = 0;
  virtual const sc_event& ResponseStartEvent(void) const = 0;
  virtual const sc_event& ResponseEndEvent(void) const = 0;
  virtual const sc_event& SThreadBusyEvent(void) const = 0;
  virtual const sc_event& SidebandSlaveEvent(void) const = 0; 
  virtual const sc_event& SidebandResetEvent(void) const = 0; 
  virtual const sc_event& SidebandControlEvent(void) const = 0;
  virtual const sc_event& SidebandStatusEvent(void) const = 0;

};

#endif // _OCP_TL2_MASTER_IF

