#ifndef __DEMOFIFO
#define __DEMOFIFO

#include <systemc.h>

template<class Td, int max> class fifo
{
   public:
     fifo() : num_elements(0), first(0) {}

     bool full () {
       return (num_elements == max);
     }

     bool empty () {
       return (num_elements == 0);
     }

     void write(Td c) {
       data[(first + num_elements) % max] = c;
       num_elements++;
     }

     Td read(){
       Td c = data[first];
       num_elements--;
       first = (first + 1) % max;
       return c;
     }

     Td peek(){
       Td c = data[first];
       return c;
     }

     bool peek_flag() {
       bool c = flag[first];
       return c;
     }

     void poke_flag(bool c) {
       flag[(first + num_elements) % max] = c;
     }

     void reset() { num_elements = first = 0; }

     int num_available() { return num_elements;}

   private:
     Td data[max];
     bool flag[max];
     unsigned int num_elements, first;
};

#endif

