//////////////////////////////////////////////////////////////////////
//
//  (c) Copyright OCP-IP 2006
//  OCP-IP Confidential and Proprietary
//
// Author: Herve Alexanian, Sonics, inc.
//
// $Id:
//
// Slave Transaction Level (TL2) model
//
//////////////////////////////////////////////////////////////////////
#ifndef _OcpIpMasterTL2_h_
#define _OcpIpMasterTL2_h_

#include <iostream>
#include <deque>
#include <vector>
#include <stdlib.h>
#include "IntTypes.h"
#include "ocp_globals.h"
#include "ocp_utils.h"
#include "ocp_tl2_master_port.h"
#include "ThreadArbiter.h"
#include "ThreadedQueue.h"

namespace OcpIp
{
class IStlReader;
class StlWaitCommand;
template <typename Td, typename Ta> class StlTransferCommand;
template <typename Td, typename Ta> class MasterTL2DataFlow;
template <typename Td, typename Ta> class MasterTL2InStream;
template <typename Td, typename Ta> class MasterTL2StlStream;

struct MasterTl2Config {
    bool timestamp_enable;
    int  req2data_latency;
    int  req_interval;
    int  respaccept_latency;
    int  mthreadbusy_cycles;

    // default values
    MasterTl2Config() :
        timestamp_enable  ( true ),
        req2data_latency  ( 0 ),
        req_interval      ( 0 ),
        respaccept_latency( 0 ),
        mthreadbusy_cycles( 0 )
        {}
};

// define the Master transactor class
template <typename Td, typename Ta>
class MasterTL2 : public sc_module {
  public:
    friend class MasterTL2DataFlow<Td,Ta>;
    friend class MasterTL2InStream<Td,Ta>;
    friend class MasterTL2StlStream<Td,Ta>;
    typedef OCPTL2RequestGrp <Td,Ta>   RequestGrp;
    typedef OCPTL2ResponseGrp<Td>      ResponseGrp;
    typedef OCP_TL2_MasterIF <Td, Ta>  OcpInterface;
    typedef MasterTL2InStream<Td,Ta>   InStream;

    MasterTL2( sc_module_name, int testStreams=0 );
    ~MasterTL2();
    OCP_TL2_MasterPort<Td, Ta> ipP;
    MasterTl2Config            m_config;
    sc_fifo_in<RequestGrp>*    getTestStreamPort( int num=-1 );

    // MFlag setting (to remedy a shortcoming of tl2 interface, no mask support)
    snx_uint64_t m_curMFlag;
    void setMFlag( snx_uint64_t value, snx_uint64_t mask );

  protected:
    virtual void before_end_of_elaboration();

    // Cached OCP parameters
    int32_t  m_threads;
    uint32_t m_tbflags;    

    // Data Flow
    ResponseGrp           m_currentResponse;
    sc_event              m_responseAcceptEvent;
    vector<InStream*>     m_inStreams;
    vector<sc_semaphore*> m_threadSemaphores;
    Sonics::ThreadedQueue<MasterTL2DataFlow<Td,Ta>*> m_responseStream;

    // Thread arbitration
    Sonics::ThreadBusyProxy*    m_pThreadBusyAccess;
    Sonics::ThreadArbiter       m_threadArbiter;

    // Burst tracking
    vector<OcpIp::BurstCounter>        m_burstCounter;
    vector<OcpIp::BurstSequence<Ta>* > m_burstSequence;

  private:
    // SystemC methods
    SC_HAS_PROCESS(MasterTL2);
    void responseThread();
    void responseAcceptMethod();
    int  m_numTestStreams;
    int  m_lastTestStreamPort;
};
}

#endif // _OcpIpMasterTL2_h_
